# import des different composants necessaires
from vtk import *

nom_du_fichier = "test.vtk"

# ------------------------------------------------
# Lecture du dataset
# ------------------------------------------------
reader = vtkDataSetReader()
reader.SetFileName(nom_du_fichier)
reader.Update()
reader.CloseVTKFile()

# ------------------------------------------------
# fin de la lecture
# ------------------------------------------------
dataset = reader.GetOutput()
outputPort = reader.GetOutputPort()

# ------------------------------------------------
# creation du pipeline de visualisation par defaut
# ------------------------------------------------
    
mapper = vtkDataSetMapper()
mapper.SetInput(dataset)
    
actor = vtkActor()
actor.SetMapper(mapper)
    
#  ------------------------------------------------
# Fin de la definition du pipeline
#  ------------------------------------------------

#  ------------------------------------------------
# Integration de l'acteur dans la vue 3D
#  ------------------------------------------------

renderer = vtkRenderer()
renWin = vtkRenderWindow()
renWin.AddRenderer(renderer)
    
iren = vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)
    
renderer.AddActor(actor)
renderer.SetBackground(1,1,1)
renderer.ResetCamera()
    
renderer.GetActiveCamera().Elevation(60.0)
renderer.GetActiveCamera().Azimuth(30.0)
renderer.GetActiveCamera().Zoom(1.25)
renWin.SetSize(300,300)
    
# interact with data
renWin.Render()
iren.Start()
    
